/*********************************************/
/* Example Program for ET-ADuC847 STAMP V1.0 */
/* MCU      : ADuC847(XTAL = 32.768 KHz)     */
/*          : Frequency Bus = 12.582912 MHz  */
/* Compiler : Keil C51 (V7.50)               */
/* Function : Demo SPI Interface 74HC595     */
/* Write By : ETT CO.,LTD.(May/2011)         */
/*********************************************/

// Test By ET-MINI 74HC595 + ET-MINI SEG-A
// -> SCK(P2.0)  = CLOCK(ET-MINI 74HC595)
// -> MOSI(P2.1) = DIN(ET-MINI 74HC595) 
// -> GPIO(P2.3) = LATCH(ET-MINI 74HC595)

/* include  section */
#include <aduc847.h>									// ADUC847 SFR : File
#include <stdio.h>                						// Prototype declarations for I/O functions

// Define Software SPI Pin Signal //
sbit SPI_SCK  = P2^0;									// SPI Pin SCK 
sbit SPI_MOSI = P2^1;									// SPI Pin MOSI 
sbit SPI_MISO = P2^2;									// SPI Pin MISO 
sbit LATCH_74HC595 = P2^3;								// GPIO Output(Latch 74HC595) 

/* User Define Function */
unsigned char SPI_Write_Byte(unsigned char);			// Write 1 Byte to SPI Bus
void delay(unsigned long);								// Delay Time Function(1..4294967295)

/*--------------------------------------------
The main C function.  Program execution Here 
---------------------------------------------*/
void main (void) 
{  	  
  const char seg_code[16]={0x3F,0x06,0x5b,0x4F,	 		// 7-Segment Code 0..9,A..F
  						   0x66,0x6D,0x7D,0x07,
						   0x7F,0x6F,0x77,0x7c,
						   0x39,0x5e,0x79,0x71};	

						  

  int  seg_ptr;											// 7-Segment Pointer Display
  unsigned char data_out;			 					// Write SPI Buffer
   
  PLLCON = 0x00;										// Initial Clock = 12.582912MHz

  /* Initial Software Signal SPI */
  SPI_MOSI = 0;											// SPI Data = "0"
  SPI_SCK = 0;  			   							// SPI Clock = "0"
  LATCH_74HC595	= 0;		 							// Prepared Latch 74HC595

  //SPI=Master,CPOL=0,CPHA=0
  SPICON  =  0x00;										// Reset All SPI Bit Config  
  SPICON |=  0x10;										// SPI = Master
  SPICON &= ~0x08;										// CPOL = 0(Idle Low)
  SPICON |=  0x04;										// CPHA = 0(Rising Edge Shift Data)
  SPICON |=  0x03;										// SPI Baud = Fcore/16
  SPICON |=  0x20;										// SPI Enable
     
  while(1)												// Loop Continue
  { 
	for(seg_ptr=0;seg_ptr<=15;seg_ptr++)				// 0..9,A..F
	{
	  data_out=seg_code[seg_ptr];						// Get Segment Code

	  LATCH_74HC595 = 0;								// Prepared Latch 74HC595	  
	  SPI_Write_Byte(~data_out);						// Active 8-Bit Output(Invert Output) 
	  LATCH_74HC595 = 1;								// Latch Output 74HC595
      
      delay (50000);	  								// Delay Display Output
    }    
  }  
}

/***************************/
/* Write 1 Byte to SPI Bus */
/***************************/
unsigned char SPI_Write_Byte(unsigned char Data)
{
  SPIDAT = Data;										// Send Byte to SPI
  while ((SPICON & 0x80) != 0x80) ; 				    // Wait For Data Received Status Bit
 
  return SPIDAT;
}

/*******************************************/
/* Long Delay Time Function(1..4294967295) */
/*******************************************/
void delay(unsigned long i)
{
  while(i > 0) {i--;}									// Loop Decrease Counter	
  return;
}

